Ext.data.JsonP.sol_common_monitoring_as_analyzers_RetentionAnalyzer({"tagname":"class","name":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.js","href":"lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer"}],"eloas":true,"requires":["sol.common.DateUtils","sol.common.RepoUtils","sol.common_monitoring.as.MonitorUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"action","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"cfg-action","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"retention","tagname":"cfg","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"cfg-retention","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"analyze","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"method-analyze","meta":{}},{"name":"calculateNextCheck","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"method-calculateNextCheck","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isObsolete","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"method-isObsolete","meta":{"private":true}},{"name":"retrieveChangedDate","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"method-retrieveChangedDate","meta":{"private":true}},{"name":"retrieveOldestChildrenChangedDate","tagname":"method","owner":"sol.common_monitoring.as.analyzers.RetentionAnalyzer","id":"method-retrieveOldestChildrenChangedDate","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common_monitoring.as.analyzers.RetentionAnalyzer","short_doc":"Analyzes, if an object is obsolete by checking if a specified retention time is exceeded. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common_monitoring.as.analyzers.RetentionAnalyzer</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common_monitoring.as.MonitorUtils' rel='sol.common_monitoring.as.MonitorUtils' class='docClass'>sol.common_monitoring.as.MonitorUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer' target='_blank'>lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.js</a></div></pre><div class='doc-contents'><p>Analyzes, if an object is obsolete by checking if a specified retention time is exceeded.</p>\n\n<p>This analyzer does that, by checking the objects (and possible children) changed date. If all changes are older then the minimum age an action will be executed.</p>\n\n<pre><code>var analyzer = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer\" rel=\"sol.common_monitoring.as.analyzers.RetentionAnalyzer\" class=\"docClass\">sol.common_monitoring.as.analyzers.RetentionAnalyzer</a>\", {\n  retention: { value: 2, unit: \"M\" },\n  action: { type: \"WORKFLOW\", templateId: \"TestMonitoring\", user: \"Administrator\" }\n});\n</code></pre>\n\n<p>For possible retention configuration see <a href=\"#!/api/sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" rel=\"sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" class=\"docClass\">sol.common_monitoring.as.MonitorUtils.evalDateUnitConfig</a>.</p>\n\n<p>The action needs to be specified, because analysers are responsible for determining the actions. This special analyzer just returns exactely one ore no action.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-action' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-cfg-action' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-cfg-action' class='name expandable'>action</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;retention&quot;, &quot;action&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-retention' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-cfg-retention' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-cfg-retention' class='name expandable'>retention</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Configuration to determine, if an object is obsolete or not (see sol.common_monitoring.as.MonitorUtils.evalDateUnitCo...</div><div class='long'><p>Configuration to determine, if an object is obsolete or not (see <a href=\"#!/api/sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" rel=\"sol.common_monitoring.as.MonitorUtils-method-evalDateUnitConfig\" class=\"docClass\">sol.common_monitoring.as.MonitorUtils.evalDateUnitConfig</a>)</p>\n<ul><li><span class='pre'>type</span> : String<div class='sub-desc'><p>(optional)</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>(optional)</p>\n</div></li><li><span class='pre'>value</span> : Number<div class='sub-desc'><p>(optional)</p>\n</div></li><li><span class='pre'>unit</span> : String|Object<div class='sub-desc'><p>(optional)</p>\n<ul><li><span class='pre'>type</span> : String<div class='sub-desc'><p>(optional)</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>(optional)</p>\n</div></li></ul></div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-analyze' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-method-analyze' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-method-analyze' class='name expandable'>analyze</a>( <span class='pre'>sord</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Analyzes if the object and all children are older than a specified retention time. ...</div><div class='long'><p>Analyzes if the object and all children are older than a specified retention time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-calculateNextCheck' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-method-calculateNextCheck' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-method-calculateNextCheck' class='name expandable'>calculateNextCheck</a>( <span class='pre'>sord, latestChange, [resultWithoutTime]</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calculates the date on which the next check should occur using retention and latestChange. ...</div><div class='long'><p>Calculates the date on which the next check should occur using <a href=\"#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-cfg-retention\" rel=\"sol.common_monitoring.as.analyzers.RetentionAnalyzer-cfg-retention\" class=\"docClass\">retention</a> and <code>latestChange</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Used to determine the retention (if it depends on indexfields)</p>\n</div></li><li><span class='pre'>latestChange</span> : Date<div class='sub-desc'><p>The most current change of the object (or any child)</p>\n</div></li><li><span class='pre'>resultWithoutTime</span> : Boolean (optional)<div class='sub-desc'><p>Defines, if the resutling ISO string should contain tzhe time or not</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isObsolete' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-method-isObsolete' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-method-isObsolete' class='name expandable'>isObsolete</a>( <span class='pre'>sord, latestChange</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if an date (latestChange) has exceeded the retention time. ...</div><div class='long'><p>Checks, if an date (<code>latestChange</code>) has exceeded the retention time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Used to determine the retention (if it depends on indexfields)</p>\n</div></li><li><span class='pre'>latestChange</span> : Date<div class='sub-desc'><p>The most current change of the object (or any child)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveChangedDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-method-retrieveChangedDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-method-retrieveChangedDate' class='name expandable'>retrieveChangedDate</a>( <span class='pre'>sord</span> ) : Date<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves an objects last changed date. ...</div><div class='long'><p>Retrieves an objects last changed date.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Date</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveOldestChildrenChangedDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_monitoring.as.analyzers.RetentionAnalyzer'>sol.common_monitoring.as.analyzers.RetentionAnalyzer</span><br/><a href='source/lib_sol.common_monitoring.as.analyzers.RetentionAnalyzer.html#sol-common_monitoring-as-analyzers-RetentionAnalyzer-method-retrieveOldestChildrenChangedDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_monitoring.as.analyzers.RetentionAnalyzer-method-retrieveOldestChildrenChangedDate' class='name expandable'>retrieveOldestChildrenChangedDate</a>( <span class='pre'>sord</span> ) : Date<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the most current last changed date of all children. ...</div><div class='long'><p>Retrieves the most current last changed date of all children.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Date</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});